<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted aceess');

class SppagebuilderAddonModal_advance extends SppagebuilderAddons
{

    public function render()
    {

        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';

        //Options
        $modal_selector = (isset($this->addon->settings->modal_selector) && $this->addon->settings->modal_selector) ? $this->addon->settings->modal_selector : '';
        $button_text = (isset($this->addon->settings->button_text) && $this->addon->settings->button_text) ? $this->addon->settings->button_text : '';
        $button_class = (isset($this->addon->settings->button_type) && $this->addon->settings->button_type) ? ' sppb-btn-' . $this->addon->settings->button_type : ' sppb-btn-default';
        $button_class .= (isset($this->addon->settings->button_size) && $this->addon->settings->button_size) ? ' sppb-btn-' . $this->addon->settings->button_size : '';
        $button_class .= (isset($this->addon->settings->button_shape) && $this->addon->settings->button_shape) ? ' sppb-btn-' . $this->addon->settings->button_shape : ' sppb-btn-rounded';
        $button_class .= (isset($this->addon->settings->button_appearance) && $this->addon->settings->button_appearance) ? ' sppb-btn-' . $this->addon->settings->button_appearance : '';
        $button_class .= (isset($this->addon->settings->button_block) && $this->addon->settings->button_block) ? ' ' . $this->addon->settings->button_block : '';
        $button_icon = (isset($this->addon->settings->button_icon) && $this->addon->settings->button_icon) ? $this->addon->settings->button_icon : '';
        $button_icon_position = (isset($this->addon->settings->button_icon_position) && $this->addon->settings->button_icon_position) ? $this->addon->settings->button_icon_position : 'left';
        //New content
        $subtitle = (isset($this->addon->settings->subtitle) && $this->addon->settings->subtitle) ? $this->addon->settings->subtitle : '';
        $title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
        $tag_name = (isset($this->addon->settings->tag_name) && $this->addon->settings->tag_name) ? $this->addon->settings->tag_name : '';

        //Title Animation
        $title_animation = (isset($this->addon->settings->title_animation) && $this->addon->settings->title_animation) ? ' sppb-wow ' . $this->addon->settings->title_animation : '';

        $title_data_attr = '';
        if (isset($this->addon->settings->title_animationduration) && $this->addon->settings->title_animationduration) {
            $title_data_attr .= ' data-sppb-wow-duration="' . $this->addon->settings->title_animationduration . 'ms"';
        }
        if (isset($this->addon->settings->title_animationdelay) && $this->addon->settings->title_animationdelay) {
            $title_data_attr .= ' data-sppb-wow-delay="' . $this->addon->settings->title_animationdelay . 'ms"';
        }
        //Subtitle Animation
        $subtitle_animation = (isset($this->addon->settings->subtitle_animation) && $this->addon->settings->subtitle_animation) ? ' sppb-wow ' . $this->addon->settings->subtitle_animation : '';

        $subtitle_data_attr = '';
        if (isset($this->addon->settings->subtitle_animationduration) && $this->addon->settings->subtitle_animationduration) {
            $subtitle_data_attr .= ' data-sppb-wow-duration="' . $this->addon->settings->subtitle_animationduration . 'ms"';
        }
        if (isset($this->addon->settings->subtitle_animationdelay) && $this->addon->settings->subtitle_animationdelay) {
            $subtitle_data_attr .= ' data-sppb-wow-delay="' . $this->addon->settings->subtitle_animationdelay . 'ms"';
        }
        //Tag Animation
        $tag_animation = (isset($this->addon->settings->tag_animation) && $this->addon->settings->tag_animation) ? ' sppb-wow ' . $this->addon->settings->tag_animation : '';

        $tag_data_attr = '';
        if (isset($this->addon->settings->tag_animationduration) && $this->addon->settings->tag_animationduration) {
            $tag_data_attr .= ' data-sppb-wow-duration="' . $this->addon->settings->tag_animationduration . 'ms"';
        }
        if (isset($this->addon->settings->tag_animationdelay) && $this->addon->settings->tag_animationdelay) {
            $tag_data_attr .= ' data-sppb-wow-delay="' . $this->addon->settings->tag_animationdelay . 'ms"';
        }

        //button
        if ($button_icon_position == 'left') {
            $button_text = ($button_icon) ? '<i class="fa ' . $button_icon . '"></i> ' . $button_text : $button_text;
        } else {
            $button_text = ($button_icon) ? $button_text . ' <i class="fa ' . $button_icon . '"></i>' : $button_text;
        }


        $selector_image = (isset($this->addon->settings->selector_image) && $this->addon->settings->selector_image) ? $this->addon->settings->selector_image : '';
        $selector_icon_name = (isset($this->addon->settings->selector_icon_name) && $this->addon->settings->selector_icon_name) ? $this->addon->settings->selector_icon_name : '';
        $alignment = (isset($this->addon->settings->alignment) && $this->addon->settings->alignment) ? $this->addon->settings->alignment : '';
        $modal_unique_id = 'sppb-modal-' . $this->addon->id;
        $modal_content_type = (isset($this->addon->settings->modal_content_type) && $this->addon->settings->modal_content_type) ? $this->addon->settings->modal_content_type : 'text';
        $modal_content_text = (isset($this->addon->settings->modal_content_text) && $this->addon->settings->modal_content_text) ? $this->addon->settings->modal_content_text : '';
        $modal_content_image = (isset($this->addon->settings->modal_content_image) && $this->addon->settings->modal_content_image) ? $this->addon->settings->modal_content_image : '';
        $modal_content_video_url = (isset($this->addon->settings->modal_content_video_url) && $this->addon->settings->modal_content_video_url) ? $this->addon->settings->modal_content_video_url : '';
        $modal_popup_width = (isset($this->addon->settings->modal_popup_width) && $this->addon->settings->modal_popup_width) ? $this->addon->settings->modal_popup_width : '';
        $modal_popup_height = (isset($this->addon->settings->modal_popup_height) && $this->addon->settings->modal_popup_height) ? $this->addon->settings->modal_popup_height : '';

        if ($modal_content_type == 'text') {
            $mfg_type = 'inline';
        } else if ($modal_content_type == 'video') {
            $mfg_type = 'iframe';
        } else if ($modal_content_type == 'image') {
            $mfg_type = 'image';
        }

        $output = '';
        $output .= '<div class="sppb-modal-content-wrapper ' . $class . '">';

        if ($modal_content_type == 'text') {
            $url = '#' . $modal_unique_id;
            $output .= '<div id="' . $modal_unique_id . '" class="mfp-hide white-popup-block">';
            $output .= $modal_content_text;
            $output .= '</div>';
            $attribs = 'data-popup_type="inline" data-mainclass="mfp-no-margins mfp-with-zoom"';
        } else if ($modal_content_type == 'video') {
            $url = $modal_content_video_url;
            $attribs = 'data-popup_type="iframe" data-mainclass="mfp-no-margins mfp-with-zoom"';
            $output .= '<div class="sppb-modal-video-content ' . $alignment . '">';
            $output .= '<h4 class="' . $subtitle_animation . '" ' . $subtitle_data_attr . '>' . $subtitle . '</h4>';
            $output .= '<h2 class="' . $title_animation . '" ' . $title_data_attr . '>' . $title . '</h2>';
            $output .= '<p class="' . $tag_animation . '" ' . $tag_data_attr . '>' . $tag_name . '</p>';
            $output .= '</div>'; //.sppb-modal-video-content
        } else {
            $url = '';
            if (isset($modal_content_image)) {
                if (is_object($modal_content_image)) {
                    $url = $modal_content_image->src;
                } elseif (is_string($modal_content_image)) {
                    $url = $modal_content_image;
                }
                if (strpos($url, "http://") === 0 || strpos($url, "https://") === 0) {
                    $url = $url;
                } else {
                    $url = JURI::base() . $url;
                }
            }
            $attribs = 'data-popup_type="image" data-mainclass="mfp-no-margins mfp-with-zoom"';
        }

        $output .= '<div class="sppb-poup-btn sppb-text-center">';

        $src = "";
        if (isset($selector_image)) {
            if (is_object($selector_image)) {
                $src = $selector_image->src;
            } elseif (is_string($selector_image)) {
                $src = $selector_image;
            }
            if (strpos($src, "http://") === 0 || strpos($src, "https://") === 0) {
                $src = $src;
            } else {
                $src = JURI::base() . $src;
            }
        }


        if ($modal_selector == 'image') {
            $output .= ($src) ? '<a class="sppb-modal-selector sppb-magnific-popup" ' . $attribs . ' href="' . $url . '" id="' . $modal_unique_id . '-selector"><img src="' . $src . '" alt=""></a>' : '';
        } else if ($modal_selector == 'icon') {
            if ($selector_icon_name) {
                $output .= '<a class="sppb-modal-selector sppb-magnific-popup" href="' . $url . '" ' . $attribs . ' id="' . $modal_unique_id . '-selector">';
                $output .= '<span>';
                $output .= '<i class="fa ' . $selector_icon_name . '"></i>';
                $output .= '</span>';
                $output .= '</a>';
            }
        } else {
            $output .= '<a class="sppb-btn ' . $button_class . ' sppb-magnific-popup sppb-modal-selector" ' . $attribs . ' href="' . $url . '" id="' . $modal_unique_id . '-selector">' . $button_text . '</a>';
        }

        $output .= '</div>';
        $output .= '</div>'; //.sppb-modal-content-wrapper

        return $output;
    }

    public function scripts()
    {
        return array(JURI::base(true) . '/components/com_sppagebuilder/assets/js/jquery.magnific-popup.min.js');
    }

    public function stylesheets()
    {
        return array(JURI::base(true) . '/components/com_sppagebuilder/assets/css/magnific-popup.css');
    }

    public function css()
    {
        $addon_id = '#sppb-addon-' . $this->addon->id;
        $css = '';
        $modal_selector = (isset($this->addon->settings->modal_selector) && $this->addon->settings->modal_selector) ? $this->addon->settings->modal_selector : '';
        $selector_icon_name = (isset($this->addon->settings->selector_icon_name) && $this->addon->settings->selector_icon_name) ? $this->addon->settings->selector_icon_name : '';
        $selector_style = (isset($this->addon->settings->selector_margin_top) && $this->addon->settings->selector_margin_top) ? 'margin-top:' . (int) $this->addon->settings->selector_margin_top . 'px;' : '';
        $selector_style .= (isset($this->addon->settings->selector_margin_bottom) && $this->addon->settings->selector_margin_bottom) ? 'margin-bottom:' . (int) $this->addon->settings->selector_margin_bottom . 'px;' : '';

        if ($modal_selector == 'icon') {
            if ($selector_icon_name) {
                $selector_style .= 'display:inline-block;line-height:1;';
                $selector_style .= (isset($this->addon->settings->selector_icon_padding) && $this->addon->settings->selector_icon_padding) ? 'padding:' . (int) $this->addon->settings->selector_icon_padding . 'px;' : '';
                $selector_style .= (isset($this->addon->settings->selector_icon_color) && $this->addon->settings->selector_icon_color) ? 'color:' . $this->addon->settings->selector_icon_color . ';' : '';
                $selector_style .= (isset($this->addon->settings->selector_icon_background) && $this->addon->settings->selector_icon_background) ? 'background-color:' . $this->addon->settings->selector_icon_background . ';' : '';
                $selector_style .= (isset($this->addon->settings->selector_icon_border_color) && $this->addon->settings->selector_icon_border_color) ? 'border-style:solid;border-color:' . $this->addon->settings->selector_icon_border_color . ';' : '';
                $selector_style .= (isset($this->addon->settings->selector_icon_border_width) && $this->addon->settings->selector_icon_border_width) ? 'border-width:' . (int) $this->addon->settings->selector_icon_border_width . 'px;' : '';
                $selector_style .= (isset($this->addon->settings->selector_icon_border_radius) && $this->addon->settings->selector_icon_border_radius) ? 'border-radius:' . (int) $this->addon->settings->selector_icon_border_radius . 'px;' : '';

                $selector_icon_style = (isset($this->addon->settings->selector_icon_size) && $this->addon->settings->selector_icon_size) ? 'font-size:' . (int) $this->addon->settings->selector_icon_size . 'px;width:' . (int) $this->addon->settings->selector_icon_size . 'px;height:' . (int) $this->addon->settings->selector_icon_size . 'px;line-height:' . (int) $this->addon->settings->selector_icon_size . 'px;' : '';

                if ($selector_style) {
                    $css .= $addon_id . ' .sppb-modal-selector span {';
                    $css .= $selector_style;
                    $css .= '}';
                }

                if ($selector_icon_style) {
                    $css .= $addon_id . ' .sppb-modal-selector span > i {';
                    $css .= $selector_icon_style;
                    $css .= '}';
                }
            }
        } else {
            if ($selector_style) {
                $css .= $addon_id . ' .sppb-modal-selector {';
                $css .= $selector_style;
                $css .= '}';
            }
        }

        //New style
        $tittle_style = (isset($this->addon->settings->title_background) && $this->addon->settings->title_background) ? 'background-color:' . $this->addon->settings->title_background . ';' : '';
        $tittle_style .= (isset($this->addon->settings->title_text_color) && $this->addon->settings->title_text_color) ? 'color:' . $this->addon->settings->title_text_color . ';' : '';
        $tittle_style .= (isset($this->addon->settings->title_font_size) && $this->addon->settings->title_font_size) ? 'font-size:' . $this->addon->settings->title_font_size . ';' : '';
        $tittle_style .= (isset($this->addon->settings->title_padding) && $this->addon->settings->title_padding) ? 'padding:' . $this->addon->settings->title_padding . ';' : '';
        $tittle_style .= (isset($this->addon->settings->title_margin) && $this->addon->settings->title_margin) ? 'margin:' . $this->addon->settings->title_margin . ';' : '';
        $tittle_style .= (isset($this->addon->settings->title_line_height) && $this->addon->settings->title_line_height) ? 'line-height:' . $this->addon->settings->title_line_height . ';' : '';
        if ($tittle_style) {
            $css .= $addon_id . ' .sppb-modal-video-content h2{';
            $css .= $tittle_style;
            $css .= '}';
        }

        $subtittle_style = (isset($this->addon->settings->subtitle_background) && $this->addon->settings->subtitle_background) ? 'background-color:' . $this->addon->settings->subtitle_background . ';' : '';
        $subtittle_style .= (isset($this->addon->settings->subtitle_text_color) && $this->addon->settings->subtitle_text_color) ? 'color:' . $this->addon->settings->subtitle_text_color . ';' : '';
        $subtittle_style .= (isset($this->addon->settings->subtitle_font_size) && $this->addon->settings->subtitle_font_size) ? 'font-size:' . $this->addon->settings->subtitle_font_size . ';' : '';
        $subtittle_style .= (isset($this->addon->settings->subtitle_padding) && $this->addon->settings->subtitle_padding) ? 'padding:' . $this->addon->settings->subtitle_padding . ';' : '';
        $subtittle_style .= (isset($this->addon->settings->subtitle_line_height) && $this->addon->settings->subtitle_line_height) ? 'line-height:' . $this->addon->settings->subtitle_line_height . ';' : '';
        $subtittle_style .= (isset($this->addon->settings->subtitle_margin) && $this->addon->settings->subtitle_margin) ? 'margin:' . $this->addon->settings->subtitle_margin . ';' : '';

        if ($subtittle_style) {
            $css .= $addon_id . ' .sppb-modal-video-content h4{';
            $css .= $subtittle_style;
            $css .= '}';
        }
        $tag_style = (isset($this->addon->settings->tag_background) && $this->addon->settings->tag_background) ? 'background-color:' . $this->addon->settings->tag_background . ';' : '';
        $tag_style .= (isset($this->addon->settings->tag_text_color) && $this->addon->settings->tag_text_color) ? 'color:' . $this->addon->settings->tag_text_color . ';' : '';
        $tag_style .= (isset($this->addon->settings->tag_font_size) && $this->addon->settings->tag_font_size) ? 'font-size:' . $this->addon->settings->tag_font_size . ';' : '';
        $tag_style .= (isset($this->addon->settings->tag_padding) && $this->addon->settings->tag_padding) ? 'padding:' . $this->addon->settings->tag_padding . ';' : '';
        $tag_style .= (isset($this->addon->settings->tag_line_height) && $this->addon->settings->tag_line_height) ? 'line-height:' . $this->addon->settings->tag_line_height . ';' : '';
        $tag_style .= (isset($this->addon->settings->tag_margin) && $this->addon->settings->tag_margin) ? 'margin:' . $this->addon->settings->tag_margin . ';' : '';

        if ($tag_style) {
            $css .= $addon_id . ' .sppb-modal-video-content p{';
            $css .= $tag_style;
            $css .= '}';
        }

        // Button css
        $layout_path = JPATH_ROOT . '/components/com_sppagebuilder/layouts';
        $css_path = new JLayoutFile('addon.css.button', $layout_path);
        $css .= $css_path->render(array('addon_id' => $addon_id, 'options' => $this->addon->settings, 'id' => 'sppb-modal-' . $this->addon->id . '-selector'));

        return $css;
    }

    public static function getTemplate()
    {
        $output = '
            <#
                var contentClass = (!_.isEmpty(data.class) && data.class) ? data.class : "";
                var modal_selector = (!_.isEmpty(data.modal_selector) && data.modal_selector) ? data.modal_selector : "";
                var button_text = (!_.isEmpty(data.button_text) && data.button_text) ? data.button_text : "";
                var button_class = (!_.isEmpty(data.button_type) && data.button_type) ? \' sppb-btn-\' + data.button_type : \' sppb-btn-default\';
                button_class += (!_.isEmpty(data.button_size) && data.button_size) ? \' sppb-btn-\' + data.button_size : "";
                button_class += (!_.isEmpty(data.button_shape) && data.button_shape) ? \' sppb-btn-\' + data.button_shape : \' sppb-btn-rounded\';
                button_class += (!_.isEmpty(data.button_appearance) && data.button_appearance) ? \' sppb-btn-\' + data.button_appearance : "";
                button_class += (!_.isEmpty(data.button_block) && data.button_block) ? \' \' + data.button_block : "";
                var button_icon = (!_.isEmpty(data.button_icon) && data.button_icon) ? data.button_icon : "";
                var button_icon_position = (!_.isEmpty(data.button_icon_position) && data.button_icon_position) ? data.button_icon_position : "left";
                var subtitle = (!_.isEmpty(data.subtitle) && data.subtitle) ? data.subtitle : "";
                var title = (!_.isEmpty(data.title) && data.title) ? data.title : "";
                var tag_name = (!_.isEmpty(data.tag_name) && data.tag_name) ? data.tag_name : "";
    
                var title_animation = (!_.isEmpty(data.title_animation) && data.title_animation) ? \' sppb-wow \' + data.title_animation : "";
    
                var title_data_attr = "";
                if (!_.isEmpty(data.title_animationduration) && data.title_animationduration) {
                    title_data_attr += \' data-sppb-wow-duration="\' + data.title_animationduration + \'ms"\';
                }
                if (!_.isEmpty(data.title_animationdelay) && data.title_animationdelay) {
                    title_data_attr += \' data-sppb-wow-delay="\' + data.title_animationdelay + \'ms"\';
                }
    
                var subtitle_animation = (!_.isEmpty(data.subtitle_animation) && data.subtitle_animation) ? \' sppb-wow \' + data.subtitle_animation : "";
    
                var subtitle_data_attr = "";
                if (!_.isEmpty(data.subtitle_animationduration) && data.subtitle_animationduration) {
                    subtitle_data_attr += \' data-sppb-wow-duration="\' + data.subtitle_animationduration + \'ms"\';
                }
                if (!_.isEmpty(data.subtitle_animationdelay) && data.subtitle_animationdelay) {
                    subtitle_data_attr += \' data-sppb-wow-delay="\' + data.subtitle_animationdelay + \'ms"\';
                }
    
                var tag_animation = (!_.isEmpty(data.tag_animation) && data.tag_animation) ? \' sppb-wow \' + data.tag_animation : "";
    
                var tag_data_attr = "";
                if (!_.isEmpty(data.tag_animationduration) && data.tag_animationduration) {
                    tag_data_attr += \' data-sppb-wow-duration="\' + data.tag_animationduration + \'ms"\';
                }
                if (!_.isEmpty(data.tag_animationdelay) && data.tag_animationdelay) {
                    tag_data_attr += \' data-sppb-wow-delay="\' + data.tag_animationdelay + \'ms"\';
                }
    
                if (button_icon_position == "left") {
                    button_text = (button_icon) ? \'<i class=" \' + button_icon + \'"></i> \' + button_text : button_text;
                } else {
                    button_text = (button_icon) ? button_text + \' <i class=" \' + button_icon + \'"></i>\' : button_text;
                }
    
                var selector_image = (!_.isEmpty(data.selector_image) && data.selector_image) ? data.selector_image : "";
                var selector_icon_name = (!_.isEmpty(data.selector_icon_name) && data.selector_icon_name) ? data.selector_icon_name : "";
                var alignment = (!_.isEmpty(data.alignment) && data.alignment) ? data.alignment : "";
                var modal_unique_id = \'sppb-modal-\' + data.id;
                var modal_content_type = (!_.isEmpty(data.modal_content_type) && data.modal_content_type) ? data.modal_content_type : "text";
                var modal_content_text = (!_.isEmpty(data.modal_content_text) && data.modal_content_text) ? data.modal_content_text : "";
                var modal_content_image = (!_.isEmpty(data.modal_content_image) && data.modal_content_image) ? data.modal_content_image : "";
                var modal_content_video_url = (!_.isEmpty(data.modal_content_video_url) && data.modal_content_video_url) ? data.modal_content_video_url : "";
                var modal_popup_width = (!_.isEmpty(data.modal_popup_width) && data.modal_popup_width) ? data.modal_popup_width : "";
                var modal_popup_height = (!_.isEmpty(data.modal_popup_height) && data.modal_popup_height) ? data.modal_popup_height : "";
    
                var mfg_type;
                if (modal_content_type == "text") {
                    mfg_type = "inline";
                } else if (modal_content_type == "video") {
                    mfg_type = "iframe";
                } else if (modal_content_type == "image") {
                    mfg_type = "image";
                }
                var url = "";
            #>
            <div class="sppb-modal-content-wrapper {{contentClass}}">
    
                <# if (modal_content_type == "text") { #>
                    <# url = \'#\' + modal_unique_id; #>
                    <div id="{{modal_unique_id}}" class="mfp-hide white-popup-block">
                        {{{modal_content_text}}}
                    </div>
                    <# var attribs = \'data-popup_type="inline" data-mainclass="mfp-no-margins mfp-with-zoom"\'; #>
                <# } else if (modal_content_type == "video") { #>
                    <# url = modal_content_video_url; #>
                    <# attribs = \'data-popup_type="iframe" data-mainclass="mfp-no-margins mfp-with-zoom"\'; #>
                    <div class="sppb-modal-video-content {{alignment}}">
                        <h4 class="{{subtitle_animation}}" {{{subtitle_data_attr}}} style="background: {{data.subtitle_background}}; color: {{data.subtitle_text_color}}; font-size: {{data.subtitle_font_size}};
                        padding: {{data.subtitle_padding}}; margin: {{data.subtitle_margin}}; line-height: {{data.subtitle_line_height}};">{{subtitle}}</h4>
    
                        <h2 class="{{title_animation}}" {{{title_data_attr}}} style="background: {{data.title_background}}; color: {{data.title_text_color}}; font-size: {{data.title_font_size}};
                        padding: {{data.title_padding}}; margin: {{data.title_margin}}; line-height: {{data.title_line_height}};">{{{title}}}</h2>
    
                        <p class="{{tag_animation}}" {{{tag_data_attr}}} style="background: {{data.tag_background}}; color: {{data.tag_text_color}}; font-size: {{data.tag_font_size}};
                        padding: {{data.tag_padding}}; margin: {{data.tag_margin}}; line-height: {{data.tag_line_height}};">{{tag_name}}</p>
                    </div>
                <# } else { #>
                    <# 
                    url = ""; 
                    if (typeof modal_content_image !== "undefined") {
                        if (typeof modal_content_image === "object") {
                            if (modal_content_image.src.indexOf("http://") === 0 || modal_content_image.src.indexOf("https://") === 0) {
                                url = `${modal_content_image.src}`;
                            } else {
                                url = `${modal_content_image.src}`;
                            }
                        } else {
                            if (modal_content_image.indexOf("http://") === 0 || modal_content_image.indexOf("https://") === 0) {
                                url = `${modal_content_image}`;
                            } else {
                                url = `${ modal_content_image}`;
                            }
                        }
                    }           
                    
                    #>
                    <# attribs = \'data-popup_type="image" data-mainclass="mfp-no-margins mfp-with-zoom"\'; #>
                <# } #>
                
                <div class="sppb-poup-btn sppb-text-center">
    
                    <# if (modal_selector == "image") { #>
                        <# 
                            var service_image = "";  // Declare service_image at the start
    
                            if (typeof selector_image !== "undefined") {
                                if (typeof selector_image === "object") {
                                    if (selector_image.src.indexOf("http://") === 0 || selector_image.src.indexOf("https://") === 0) {
                                        service_image = `${selector_image.src}`;
                                    } else {
                                        service_image = `${selector_image.src}`;
                                    }
                                } else {
                                    if (selector_image.indexOf("http://") === 0 || selector_image.indexOf("https://") === 0) {
                                        service_image = `${selector_image}`;
                                    } else {
                                        service_image = `${ selector_image}`;
                                    }
                                }
                            }
                        #>
    
                        <a class="sppb-modal-selector sppb-magnific-popup" {{{attribs}}} href="{{url}}" id="{{modal_unique_id}}-selector">
                            <img src="{{service_image}}" alt="">
                        </a>
                    <# } else if (modal_selector == "icon") { #>
                        <# if (selector_icon_name) { #>
                            <a class="sppb-modal-selector sppb-magnific-popup" href="{{url}}" {{{attribs}}} id="{{modal_unique_id}}-selector">
                                <span style="display: inline-block; line-height: 1; font-size: {{data.selector_icon_size}}px; color: {{data.selector_icon_color}};
                                background: {{data.selector_icon_background}}; border-color: {{data.selector_icon_border_color}}; border-width: {{data.selector_icon_border_width}}px; border-style: solid; border-radius: {{data.selector_icon_border_radius}}px; padding: {{data.selector_icon_padding}}px;">
                                    <i class="{{selector_icon_name}}" style="font-size: {{data.selector_icon_size}}px; width: {{data.selector_icon_size}}px; height: {{data.selector_icon_size}}px; line-height: {{data.selector_icon_size}}px;"></i>
                                </span>
                            </a>
                        <# } #>
                    <# } else { #>
                        <a class="sppb-btn {{button_class}} sppb-magnific-popup sppb-modal-selector" {{{attribs}}} href="{{url}}" id="{{modal_unique_id}}-selector">{{{button_text}}}</a>
                    <# } #>
    
                </div>
            </div>
        ';
        return $output;
    }
}
