<?php
/**
 * @package Helix3 Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

?>
<div class="latestnews">
	<?php foreach ($list as $item) {

		$attrbs 		= json_decode($item->attribs);
		$images 		= json_decode($item->images);
		$intro_image 	= '';
		$image_intro 	= ($images->image_intro) ? $images->image_intro : $item->title;


		if(isset($attrbs->spfeatured_image) && $attrbs->spfeatured_image != '') {

			$intro_image = $attrbs->spfeatured_image;
			$basename = basename($intro_image);
			$list_image = JPATH_ROOT . '/' . dirname($intro_image) . '/' . JFile::stripExt($basename) . '_thumbnail.' . JFile::getExt($basename);
			if(file_exists($list_image)) {
				$thumb_image = Uri::root(true) . '/' . dirname($intro_image) . '/' . JFile::stripExt($basename) . '_thumbnail.' . JFile::getExt($basename);
			}

		} elseif(isset($images->image_intro) && !empty($images->image_intro)) {
			$thumb_image = $images->image_intro;
		}

		?>
		<div itemscope itemtype="http://schema.org/Article">
			<?php if (!empty($thumb_image)) {?>
				<div class="img-responsive article-list-img">
					<img src="<?php echo $thumb_image; ?>" alt="<?php echo $image_intro; ?>">
				</div>
			<?php } ?>

			<a href="<?php echo $item->link; ?>" class="soccer-news-title" itemprop="url">
				<span itemprop="name">
					<?php echo $item->title; ?>
				</span>
			</a>
		</div>
	<?php } ?>
</div>
