<?php

/**
 * @package Helix3 Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

//no direct accees
defined('_JEXEC') or die('resticted aceess');

use Joomla\CMS\Language\Text;

class Helix3FeatureMenu
{

	private $helix3;
	public $position;

	public function __construct($helix3)
	{
		$this->helix3 = $helix3;
		$this->position = 'menu';
	}

	public function renderFeature()
	{

		$menu_type = $this->helix3->getParam('menu_type');

		ob_start();

		if ($menu_type == 'mega_offcanvas') { ?>
			<div class='sp-megamenu-wrapper'>
				<a id="offcanvas-toggler" href="#" aria-label="<?php echo Text::_('HELIX_MENU'); ?>"><i class="icon icon-hamburger" title="<?php echo Text::_('HELIX_MENU'); ?>"></i></a>
				<div class="sp-megamenu-toggler d-none d-md-block">
					<?php $this->helix3->loadMegaMenu('d-none d-md-block '); ?>
					<i class="open icon icon-hamburger"></i>
					<i class="close icon icon-cancle"></i>
				</div>
			</div>
		<?php } else if ($menu_type == 'mega') { ?>
			<div class='sp-megamenu-wrapper'>
				<div class="sp-megamenu-toggler d-none d-md-block">
					<?php $this->helix3->loadMegaMenu('hidden-sm hidden-xs'); ?>
					<i class="open icon icon-hamburger"></i>
					<i class="close icon icon-cancle"></i>
				</div>
				<a id="offcanvas-toggler" class="d-block d-md-none" href="#"><i class="icon icon-hamburger"></i></a>
			</div>
		<?php } else { ?>
			<a id="offcanvas-toggler" href="#"><i class="icon icon-hamburger"></i></a>
<?php }

		return ob_get_clean();
	}
}
